CREATE OR REPLACE FUNCTION tartikel.getlagerortchargetot(
   _aknr       varchar,
   _beistell   bool = false,
   _direktlief bool = false,
   _agnr_for_zwischenlagerort varchar = null,
   _forcelgort varchar = null,
   _preferABK  integer = null,

   OUT lgid integer,
   OUT lgort varchar(100),
   OUT lgchnr varchar(100),
   OUT lganztot numeric(12,4)
) RETURNS RECORD AS $$

    --- #12299 [DB-Strukturen] FUNCTION tartikel.getlagerortchargetot - abruf mit altem Funktionsname
    SELECT tartikel.art__lag__lg_anztot__by__inputparams(
       _aknr,
       _beistell,
       _direktlief,
       _agnr_for_zwischenlagerort,
       _forcelgort,
       _preferABK
    );

$$ LANGUAGE sql;

--- #13471 [DB-Strukturen] split_lagerort > TLager.lag__lagort__bereich__split
CREATE OR REPLACE FUNCTION Z_99_Deprecated.split_lagerort(
   IN _lagerort VARCHAR,
   OUT lgort VARCHAR,
   OUT lagort VARCHAR,
   OUT lagbereich VARCHAR
) RETURNS RECORD AS $$
BEGIN
   --
   SELECT * INTO lgort, lagort, lagbereich FROM TLager.lag__lagort__bereich__split( _lagerort );

END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION Z_99_Deprecated.generate_lagerort(lagbereich VARCHAR, lagort VARCHAR) RETURNS VARCHAR AS $$
    SELECT * FROM TLager.lag__lagort__bereich__generate(lagbereich, lagort);
  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_Get_Dok_Exists( _dbrid varchar ) RETURNS boolean AS $$
     SELECT TDMS.Dokument__exists__by__dbrid( _dbrid );
  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_Get_Dok_Exists_ByKeyWord(
      _kategorie varchar,
      _descr varchar
  )
  RETURNS boolean
  AS $$

      SELECT TDMS.Dokument__exists__by__keyword( _kategorie, _descr );

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetDokID(
      _dbrid varchar,
      _doktype varchar,
      _tablename varchar = null,
      _dokident varchar = null
  )
  RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__by__pd_dbrid__pd_doktype( _dbrid, _doktype, _tablename, _dokident );

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetDokID_ByIdent(
      _dokident varchar,
      _doktype varchar,
      _tablename varchar,
      _dbrid varchar = null
  )
  RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__by__pd_dokident__pd_doktype( _dokident, _doktype, _tablename, _dbrid )
  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetDokID_ByIdent(
      _dokident varchar,
      _doktypes varchar[],
      _tablename varchar
  )
  RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__by__pd_dokident__pd_doktypes( _dokident, _doktypes, _tablename )

 $$ LANGUAGE sql STABLE;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetStandardDokID( _dbrid varchar ) RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__standard_pd_print__by__dbrid( _dbrid );
  $$ LANGUAGE sql STABLE;

--- #17765
CREATE OR REPLACE FUNCTION  z_99_deprecated.stklfromwendattodatebyldid(
        _date date,
        _aknr varchar,
        _ldid integer
    ) RETURNS numeric
    AS $$

        SELECT TLager.wendat__w_zugang__by__ld_id__sum__stichtag( _date, _aknr, _ldid );

    $$ LANGUAGE sql STABLE;

CREATE OR REPLACE FUNCTION z_99_deprecated.stklfromwendattodatebyagid(
        _date date,
        _aknr varchar,
        _agid integer
      ) RETURNS numeric
      AS $$

        SELECT TLager.wendat__w_zugang__by__ag_id__sum__stichtag( _date, _aknr, _agid );

    $$ LANGUAGE sql STABLE;
---

CREATE OR REPLACE FUNCTION z_99_deprecated.get_stundenkonto(
      _minr       integer,
      _ende_datum date = current_date
  )
  RETURNS numeric
  AS $$

      SELECT TPersonal.llv__mitpln__ll_stuko__stundenkonto__calc( _minr, _ende_datum )

  $$ LANGUAGE sql STABLE;


CREATE OR REPLACE FUNCTION z_99_deprecated.mitpln_PresentDays(
      minr integer,
      anfd date,
      endd date = current_date
  )
  RETURNS numeric
  AS $$

     SELECT TPersonal.mitpln__attandance_day__count( minr, anfd, endd )::numeric;
  $$ LANGUAGE sql STABLE;
--
-- siehe: 2021-10-20
-- FUNCTION tpersonal.llv_urlaub_rest
-- FUNCTION tpersonal.llv_urlaub_anspruch
-- FUNCTION tpersonal.ll_urlaub_act



SELECT true; --SELECT am File Ende

